<?php
session_start();
include '../../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if form is submitted
    if(isset($_POST['submit'])) {


        $filepath = "../../assets/images/" . htmlspecialchars($_FILES["photo1"]["name"], ENT_QUOTES, 'UTF-8');

        if (move_uploaded_file($_FILES["photo1"]["tmp_name"], $filepath)) {
            $img1= htmlspecialchars($_FILES["photo1"]["name"], ENT_QUOTES, 'UTF-8');
        } else {
            echo "Error !!";
        }

// Retrieve form data
        $branch = $_POST['branch'];
        $assettype = $_POST['assettype'];
        $valuation_dates = $_POST['valuation_date'];
        $value_amounts = $_POST['value_amount'];
        $purchase_date = $_POST['purchase_date'];
        $price = $_POST['purchase_price'];
        $value = $_POST['replace_value'];

        // Iterate through submitted data and insert into database
        foreach($valuation_dates as $key => $valuation_date) {
            $value_amount = $value_amounts[$key];

            // Insert data into database table
            $stmt = $conn->prepare("INSERT INTO `asset`(branch,assettype,valuation_date, value_amount,purchase_date,purchase_price,replace_value,photo1) VALUES (:branch,:assettype,:valuation_date,:value_amount,:purchase_date,:price,:value,:img1)");

             $stmt->bindParam(':branch', $branch);

             $stmt->bindParam(':assettype', $assettype);
            $stmt->bindParam(':valuation_date', $valuation_date);
            $stmt->bindParam(':value_amount', $value_amount);
             $stmt->bindParam(':purchase_date', $purchase_date);
           $stmt->bindParam(':price', $price);
            $stmt->bindParam(':value', $value);
$stmt->bindParam(':img1', $img1);

            $stmt->execute();
        }

        // Redirect back to the form or any other page after insertion
        header("Location:../manage_asset.php");
        exit();
    }




//update assets
if (isset($_POST['update'])) {


     // Update secondary photo
       if (!empty($_FILES['photo1']['tmp_name'])) {
            $file_extension = pathinfo($_FILES["photo1"]["name"], PATHINFO_EXTENSION);
            $new_filename = uniqid() . '.' . $file_extension;
            $filepath = "../assets/images/" . $new_filename;
            if (move_uploaded_file($_FILES["photo1"]["tmp_name"], $filepath)) {
                $img = $new_filename;
                @unlink("../assets/images/" . htmlspecialchars($_POST['old_photo_img'], ENT_QUOTES, 'UTF-8'));
            } else {
                // Handle failed upload
                // You might want to add error handling here
            }
        } else {
            // Keep the old photo if no new one is uploaded
            $img1 = htmlspecialchars($_POST['old_photo_img'], ENT_QUOTES, 'UTF-8');
        }

$id = $_POST['id'];
    $branch = $_POST['branch'];
     $assettype = $_POST['assettype'];
    $valuation_dates = $_POST['valuation_date'];
    $value_amounts = $_POST['value_amount'];
    $purchase_date = $_POST['purchase_date'];

        $price = $_POST['purchase_price'];
        $value = $_POST['replace_value'];

    // Update asset table
    $stmt = $conn->prepare("UPDATE `asset` SET branch = :branch,assettype = :assettype, purchase_date = :purchase_date,purchase_price=:purchase_price,replace_value=:replace_value WHERE id = :id");
    $stmt->bindParam(':branch', $branch);
      $stmt->bindParam(':assettype', $assettype);
    $stmt->bindParam(':purchase_date', $purchase_date);
    $stmt->bindParam(':purchase_price', $purchase_price);
    $stmt->bindParam(':replace_value', $replace_value);
    $stmt->bindParam(':id', $id);
    $stmt->execute();

    // Update valuation table
    $stmt2 = $conn->prepare("UPDATE `asset` SET valuation_date = :valuation_date, value_amount = :value_amount WHERE id = :id");
    foreach ($valuation_dates as $index => $valuation_date) {
        $stmt2->bindParam(':valuation_date', $valuation_date);
        $stmt2->bindParam(':value_amount', $value_amounts[$index]);
        $stmt2->bindParam(':id', $id);
        $stmt2->execute();
    }

    // Redirect to a success page
    header("Location: ../manage_asset.php");
    exit();
}


//delete asset

if (isset($_POST['del_id'])) {

        $stmt = $conn->prepare("UPDATE `soul_winning` SET delete_status='1' where id=? ");

        $stmt->execute([htmlspecialchars($_POST['del_id'], ENT_QUOTES, 'UTF-8')]);

        $_SESSION['delete'] = "delete";

        header("location:../manage_asset.php");
    }



} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>