<?php
session_start();
include '../assets/constant/config.php';

try {
  $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
  $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo "Connection failed: " . $e->getMessage();
}
?>
<?php include('include/sidebar.php'); ?>

<?php include('include/header.php'); ?>

<!--  connect author at mdkhairnar92@gmail.com  -->

<div class="page-content-wrapper ">

  <div class="container-fluid">

    <div class="row">
      <div class="col-sm-12">
        <div class="page-title-box">
          <div class="btn-group float-right">


          </div>
          <h4 class="page-title">Add Follow Ups Category</h4>
        </div>
      </div>
      <div class="clearfix"></div>
    </div>
    <!-- end page title end breadcrumb -->
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">

            <div class="tab-content">

              <div class="tab-pane active p-3" id="home" role="tabpanel">
                <form name="myform" action="app/followupcategory_crud.php" class="row" method="POST" enctype="multipart/form-data" onsubmit="return validation()" id="add_service">

                    <?php
                  $stmt = $conn->prepare("SELECT * FROM `followup_category` WHERE id=? ");
                  $stmt->execute([$_POST['id']]);
                  $record = $stmt->fetchAll();

                  foreach ($record as $key) { ?>
                    <input class="form-control" type="hidden" name="id" value="<?php echo $key['id']; ?>">


                  <div class="form-group col-md-6">
                    <label class="control-label">Name<span class="text-danger">*</span></label>
                    <input class="form-control" type="text" name="name" placeholder="Enter name"  value="<?php echo $key['name'] ?>"/>
                  </div>

                 <div class="form-group col-md-6">
                    <label class="control-label">Day<span class="text-danger">*</span></label>
                    <input class="form-control" type="number" name="day"  value="<?php echo $key['day'] ?>" />
                  </div>


                  <div class="form-group col-md-6">
                                    <label>Note<span class="text-danger">*</span></label>
                                    <textarea name="note" class="form-control text-area-5" placeholder="Enter note"> <?php echo $key['note'] ?></textarea>
                                     </div>

                  
                    <div class="form-group col-md-12">

                    <button class="btn btn-primary" type="submit" name="submit" onclick="addService()">Save</button>

                  </div>
                   <?php } ?>
                </form>
              </div>


            </div>

          </div>
        </div><!--end card-->
      </div><!--end col-->
    </div><!--end row-->
  </div> <!-- Page content Wrapper -->
</div> <!-- content -->

<?php include('include/footer.php'); ?>
<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->


<script>
function addService() {
        jQuery.validator.addMethod("alphanumeric", function(value, element) {
            return this.optional(element) || /^(?=.[a-zA-Z])[a-zA-Z0-9\s!@#$%^&()_-]+$/.test(value);
        }, "Please enter alphanumeric characters only");

        jQuery.validator.addMethod("lettersonly", function(value, element) {
            return this.optional(element) || /^[a-zA-Z\s]*$/.test(value);
        }, "Please enter alphabet characters only");
  
    $('#add_service').validate({
      rules: {
        name: {
          required: true,
          alphanumeric: true
        },
      day: {
          required: true
          
        },

 note: {
          required: true
        }
      },
      messages: {
        name: {
          required: "Please enter the name",
          alphanumeric: "Only alphanumeric characters are allowed"
        },
        note: {
          required: "Please enter the notes"
        }
      }
    });
}
</script>