<?php 
session_start();
include '../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit();
}
?>

<?php include('include/sidebar.php');?>

<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->
<?php include('include/header.php');?>

<div class="content-body mb-5 p-3">
    <div class="row">
        <div class="col-md-12">
            <div class="heading mb-4 d-flex align-items-center justify-content-between">
                <h3 class="mb-0">Import File</h3>
                <p class="m-0"><a href="dashboard.php" class="text-primary">Dashboard</a><span>/ Import </span></p>
            </div>
        </div>
    </div>
    <div class="row">
        <form class="row" method="POST" action="" enctype="multipart/form-data">
            <div class="mb-3 col-md-12">
                <label class="form-label">Upload file</label>
                <a href="app/user.csv" style="color:blue">(Download Sample CSV File)</a>
                <input type="file" class="form-control" name="event_file" required>
            </div>
            <div class="mb-3 col-md-12">
                <button type="submit" name="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
</div>

<link rel="stylesheet" href="../assets/css/popup_style.css">

<?php
if (isset($_POST['submit'])) {
    if ($_FILES['event_file']['error'] === UPLOAD_ERR_OK) {
        $filename = $_FILES['event_file']['tmp_name'];
        $fileinfo = pathinfo($_FILES['event_file']['name']);
        $extension = strtolower($fileinfo['extension']);

        // Check if the file extension is csv
        if ($extension !== 'csv') {
            echo 'Please upload only a CSV file';
        } elseif ($_FILES['event_file']['size'] > 0) {
            $file = fopen($filename, 'r');
            $cnt = 0;

            // Skip the header line
            fgetcsv($file, 1000, ",");

            while (($data = fgetcsv($file, 1000, ",")) !== FALSE) {
                if (!empty($data[0]) && !empty($data[1]) && !empty($data[2])) {
                    $sql = "INSERT INTO `donar`(`name`, `email`, `mobileno`) VALUES (?, ?, ?)";
                    $statement = $conn->prepare($sql);
                    $statement->bindParam(1, $data[0]);
                    $statement->bindParam(2, $data[1]);
                    $statement->bindParam(3, $data[2]);
                    $statement->execute();
                    $cnt++;
                }
            }

            fclose($file);

            if ($cnt > 0) {
                echo '<div class="popup popup--icon -success js_success-popup popup--visible">
                        <div class="popup__background"></div>
                        <div class="popup__content">
                            <h3 class="popup__content__title">Success</h3>
                            <p>' . $cnt . ' Number of Records Successfully Added</p>
                            <p>
                                <script>setTimeout("location.href = \'manage_user1.php\';", 1500);</script>
                            </p>
                        </div>
                      </div>';
            } else {
                echo '<div class="popup popup--icon -error js_error-popup popup--visible">
                        <div class="popup__background"></div>
                        <div class="popup__content">
                            <h3 class="popup__content__title">Error</h3>
                            <p>No records were added.</p>
                            <p>
                                <script>setTimeout("location.href = \'manage_user1.php\';", 1500);</script>
                            </p>
                        </div>
                      </div>';
            }
        } else {
            echo 'File is empty';
        }
    } else {
        echo 'File upload error';
    }
}
?>

<?php include('include/footer.php');?>